package polymorphicTypes;

// We exploit a library function type for simplicity
import java.util.function.Function;

public class ChurchEncodingSumExample2 {

	// A sum type, Church-encoded
	interface Sum<A,B> {
		// <R> means "forall R."
		<R> R elim(Function<A,R> case1, Function<B,R> case2);
	}
	// The injections
	static class In1<A,B> implements Sum<A,B> {
		A a;
		In1(A a) {
			this.a = a;
		}
		@Override
		public <R> R elim(Function<A,R> case1, Function<B,R> case2) {
			return case1.apply(a);
		}
	}
	static class In2<A,B> implements Sum<A,B> {
		B b;
		In2(B b) {
			this.b = b;
		}
		@Override
		public <R> R elim(Function<A,R> case1, Function<B,R> case2) {
			return case2.apply(b);
		}
	}
	
	
	public static void main(String[] args) {
		// introduction
		Sum<Integer, String> s = new In1<>(4);
		Sum<Integer, String> t = new In2<>("shrdlu");
		
		// elimination
		String res;
		res = s.elim((Integer i) -> "int: "+i,
			         (String z) -> "string: "+z);
		System.out.println(res);
		res = t.elim((Integer i) -> "int: "+i,
					 (String z) -> "string: "+z);
		System.out.println(res);
	}

}
